/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.IdFunctionCall;
import org.mozilla.javascript.IdFunctionObject;
import org.mozilla.javascript.NativeJavaPackage;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.Wrapper;

public class NativeJavaTopPackage
extends NativeJavaPackage
implements Function,
IdFunctionCall {
    static final long serialVersionUID = -1455787259477709999L;
    private static final String[][] commonPackages = new String[][]{{"java", "lang", "reflect"}, {"java", "io"}, {"java", "math"}, {"java", "net"}, {"java", "util", "zip"}, {"java", "text", "resources"}, {"java", "applet"}, {"javax", "swing"}};
    private static final Object FTAG = "JavaTopPackage";
    private static final int Id_getClass = 1;

    NativeJavaTopPackage(ClassLoader loader) {
        super(true, "", loader);
    }

    public Object call(Context cx, Scriptable scope, Scriptable thisObj, Object[] args2) {
        return this.construct(cx, scope, args2);
    }

    public Scriptable construct(Context cx, Scriptable scope, Object[] args2) {
        ClassLoader loader = null;
        if (args2.length != 0) {
            Object arg = args2[0];
            if (arg instanceof Wrapper) {
                arg = ((Wrapper)arg).unwrap();
            }
            if (arg instanceof ClassLoader) {
                loader = (ClassLoader)arg;
            }
        }
        if (loader == null) {
            Context.reportRuntimeError0("msg.not.classloader");
            return null;
        }
        NativeJavaPackage pkg = new NativeJavaPackage(true, "", loader);
        ScriptRuntime.setObjectProtoAndParent(pkg, scope);
        return pkg;
    }

    public static void init(Context cx, Scriptable scope, boolean sealed) {
        ClassLoader loader = cx.getApplicationClassLoader();
        NativeJavaTopPackage top = new NativeJavaTopPackage(loader);
        top.setPrototype(NativeJavaTopPackage.getObjectPrototype(scope));
        top.setParentScope(scope);
        for (int i = 0; i != commonPackages.length; ++i) {
            NativeJavaPackage parent = top;
            for (int j = 0; j != commonPackages[i].length; ++j) {
                parent = parent.forcePackage(commonPackages[i][j], scope);
            }
        }
        IdFunctionObject getClass = new IdFunctionObject(top, FTAG, 1, "getClass", 1, scope);
        String[] topNames = ScriptRuntime.getTopPackageNames();
        NativeJavaPackage[] topPackages = new NativeJavaPackage[topNames.length];
        for (int i = 0; i < topNames.length; ++i) {
            topPackages[i] = (NativeJavaPackage)top.get(topNames[i], (Scriptable)top);
        }
        ScriptableObject global = (ScriptableObject)scope;
        if (sealed) {
            getClass.sealObject();
        }
        getClass.exportAsScopeProperty();
        global.defineProperty("Packages", top, 2);
        for (int i = 0; i < topNames.length; ++i) {
            global.defineProperty(topNames[i], topPackages[i], 2);
        }
    }

    public Object execIdCall(IdFunctionObject f2, Context cx, Scriptable scope, Scriptable thisObj, Object[] args2) {
        if (f2.hasTag(FTAG) && f2.methodId() == 1) {
            return this.js_getClass(cx, scope, args2);
        }
        throw f2.unknown();
    }

    private Scriptable js_getClass(Context cx, Scriptable scope, Object[] args2) {
        if (args2.length > 0 && args2[0] instanceof Wrapper) {
            int index2;
            String propName;
            Object prop;
            Scriptable result2 = this;
            Class<?> cl = ((Wrapper)args2[0]).unwrap().getClass();
            String name = cl.getName();
            int offset = 0;
            while ((prop = result2.get(propName = (index2 = name.indexOf(46, offset)) == -1 ? name.substring(offset) : name.substring(offset, index2), result2)) instanceof Scriptable) {
                result2 = (Scriptable)prop;
                if (index2 == -1) {
                    return result2;
                }
                offset = index2 + 1;
            }
        }
        throw Context.reportRuntimeError0("msg.not.java.obj");
    }
}

